/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geomgraph.index;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.locationtech.jts.geomgraph.Edge;
import org.locationtech.jts.geomgraph.index.EdgeSetIntersector;
import org.locationtech.jts.geomgraph.index.MonotoneChain;
import org.locationtech.jts.geomgraph.index.MonotoneChainEdge;
import org.locationtech.jts.geomgraph.index.SegmentIntersector;
import org.locationtech.jts.geomgraph.index.SweepLineEvent;

public class SimpleMCSweepLineIntersector
extends EdgeSetIntersector {
    List events = new ArrayList();
    int nOverlaps;

    public void computeIntersections(List edges, SegmentIntersector si, boolean testAllSegments) {
        if (testAllSegments) {
            this.addEdges(edges, null);
        } else {
            this.addEdges(edges);
        }
        this.computeIntersections(si);
    }

    public void computeIntersections(List edges0, List edges1, SegmentIntersector si) {
        this.addEdges(edges0, edges0);
        this.addEdges(edges1, edges1);
        this.computeIntersections(si);
    }

    private void addEdges(List edges) {
        for (Edge edge : edges) {
            this.addEdge(edge, edge);
        }
    }

    private void addEdges(List edges, Object edgeSet) {
        for (Edge edge : edges) {
            this.addEdge(edge, edgeSet);
        }
    }

    private void addEdge(Edge edge, Object edgeSet) {
        MonotoneChainEdge mce = edge.getMonotoneChainEdge();
        int[] startIndex = mce.getStartIndexes();
        for (int i = 0; i < startIndex.length - 1; ++i) {
            MonotoneChain mc = new MonotoneChain(mce, i);
            SweepLineEvent insertEvent = new SweepLineEvent(edgeSet, mce.getMinX(i), mc);
            this.events.add(insertEvent);
            this.events.add(new SweepLineEvent(mce.getMaxX(i), insertEvent));
        }
    }

    private void prepareEvents() {
        Collections.sort(this.events);
        for (int i = 0; i < this.events.size(); ++i) {
            SweepLineEvent ev = (SweepLineEvent)this.events.get(i);
            if (!ev.isDelete()) continue;
            ev.getInsertEvent().setDeleteEventIndex(i);
        }
    }

    private void computeIntersections(SegmentIntersector si) {
        this.nOverlaps = 0;
        this.prepareEvents();
        for (int i = 0; i < this.events.size(); ++i) {
            SweepLineEvent ev = (SweepLineEvent)this.events.get(i);
            if (ev.isInsert()) {
                this.processOverlaps(i, ev.getDeleteEventIndex(), ev, si);
            }
            if (si.isDone()) break;
        }
    }

    private void processOverlaps(int start, int end, SweepLineEvent ev0, SegmentIntersector si) {
        MonotoneChain mc0 = (MonotoneChain)ev0.getObject();
        for (int i = start; i < end; ++i) {
            SweepLineEvent ev1 = (SweepLineEvent)this.events.get(i);
            if (!ev1.isInsert()) continue;
            MonotoneChain mc1 = (MonotoneChain)ev1.getObject();
            if (ev0.isSameLabel(ev1)) continue;
            mc0.computeIntersections(mc1, si);
            ++this.nOverlaps;
        }
    }
}

