/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;

class SliceExecutor {
    private final Executor executor;

    public SliceExecutor(Executor executor) {
        this.executor = executor;
    }

    public void invokeAll(Collection<? extends Runnable> tasks) {
        if (tasks == null) {
            throw new IllegalArgumentException("Tasks is null");
        }
        if (this.executor == null) {
            throw new IllegalArgumentException("Executor is null");
        }
        int i = 0;
        for (Runnable runnable2 : tasks) {
            boolean shouldExecuteOnCallerThread = false;
            if (i == tasks.size() - 1) {
                shouldExecuteOnCallerThread = true;
            }
            this.processTask(runnable2, shouldExecuteOnCallerThread);
            ++i;
        }
    }

    protected void processTask(Runnable task, boolean shouldExecuteOnCallerThread) {
        if (task == null) {
            throw new IllegalArgumentException("Input is null");
        }
        if (!shouldExecuteOnCallerThread) {
            try {
                this.executor.execute(task);
                return;
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
        task.run();
    }
}

