/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.organization.jpa;

import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Stream;
import org.keycloak.common.util.Time;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OrganizationInvitationModel;
import org.keycloak.models.OrganizationModel;
import org.keycloak.models.jpa.PaginationUtils;
import org.keycloak.models.jpa.entities.OrganizationInvitationEntity;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.organization.InvitationManager;
import org.keycloak.organization.jpa.JpaInvitationManager;
import org.keycloak.representations.idm.OrganizationInvitationRepresentation;
import org.keycloak.utils.StreamsUtil;

record JpaInvitationManager(KeycloakSession session, EntityManager em) implements InvitationManager
{
    public OrganizationInvitationModel create(OrganizationModel organization, String email, String firstName, String lastName) {
        String id = KeycloakModelUtils.generateId();
        OrganizationInvitationEntity entity = new OrganizationInvitationEntity(id, organization.getId(), email.trim(), firstName != null ? firstName.trim() : null, lastName != null ? lastName.trim() : null);
        entity.setExpiresAt(this.getExpiration());
        this.em.persist((Object)entity);
        return entity;
    }

    public OrganizationInvitationModel getById(String id) {
        OrganizationInvitationEntity entity = (OrganizationInvitationEntity)this.em.find(OrganizationInvitationEntity.class, (Object)id);
        if (entity == null) {
            return null;
        }
        return entity;
    }

    public Stream<OrganizationInvitationModel> getAllStream(OrganizationModel organization, Map<OrganizationInvitationModel.Filter, String> attributes, Integer first, Integer max) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(OrganizationInvitationEntity.class);
        Root root = query.from(OrganizationInvitationEntity.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)root.get("organizationId"), (Object)organization.getId()));
        for (Map.Entry<OrganizationInvitationModel.Filter, String> filter : attributes.entrySet()) {
            switch (1.$SwitchMap$org$keycloak$models$OrganizationInvitationModel$Filter[filter.getKey().ordinal()]) {
                case 1: {
                    predicates.add(builder.like((Expression)root.get("email"), builder.literal((Object)("%" + filter.getValue().toLowerCase() + "%"))));
                    break;
                }
                case 2: {
                    OrganizationInvitationRepresentation.Status value = OrganizationInvitationRepresentation.Status.valueOf((String)filter.getValue());
                    if (OrganizationInvitationRepresentation.Status.EXPIRED.equals((Object)value)) {
                        predicates.add(builder.lessThan((Expression)root.get("expiresAt"), (Comparable)Integer.valueOf(Time.currentTime())));
                        break;
                    }
                    predicates.add(builder.greaterThanOrEqualTo((Expression)root.get("expiresAt"), (Comparable)Integer.valueOf(Time.currentTime())));
                    break;
                }
                case 3: {
                    predicates.add(builder.equal((Expression)root.get("firstName"), builder.literal((Object)("%" + filter.getValue().toLowerCase() + "%"))));
                    break;
                }
                case 4: {
                    predicates.add(builder.equal((Expression)root.get("lastName"), builder.literal((Object)("%" + filter.getValue().toLowerCase() + "%"))));
                    break;
                }
                case 5: {
                    String searchValue = "%" + filter.getValue().toLowerCase() + "%";
                    Predicate emailPredicate = builder.like(builder.lower((Expression)root.get("email")), searchValue);
                    Predicate firstNamePredicate = builder.like(builder.lower((Expression)root.get("firstName")), searchValue);
                    Predicate lastNamePredicate = builder.like(builder.lower((Expression)root.get("lastName")), searchValue);
                    predicates.add(builder.or(new Predicate[]{emailPredicate, firstNamePredicate, lastNamePredicate}));
                }
            }
        }
        query.where(predicates.toArray(new Predicate[0]));
        TypedQuery typedQuery = this.em.createQuery(query);
        return StreamsUtil.closing(PaginationUtils.paginateQuery((TypedQuery)typedQuery, (Integer)first, (Integer)max).getResultStream().map(OrganizationInvitationModel.class::cast));
    }

    public boolean remove(String id) {
        OrganizationInvitationEntity invitation = (OrganizationInvitationEntity)this.getById(id);
        if (invitation == null) {
            return false;
        }
        this.em.remove((Object)invitation);
        return true;
    }

    private int getExpiration() {
        return Time.currentTime() + this.session.getContext().getRealm().getActionTokenGeneratedByAdminLifespan();
    }
}

