/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Constraint;
import org.hibernate.mapping.Table;

public class UniqueKey
extends Constraint {
    private final Map<Column, String> columnOrderMap = new HashMap<Column, String>();
    private boolean nameExplicit;
    private boolean explicit;

    public UniqueKey(Table table) {
        super(table);
    }

    @Deprecated(since="7")
    public UniqueKey() {
    }

    public void addColumn(Column column, String order) {
        this.addColumn(column);
        if (StringHelper.isNotEmpty(order)) {
            this.columnOrderMap.put(column, order);
        }
    }

    public Map<Column, String> getColumnOrderMap() {
        return this.columnOrderMap;
    }

    @Override
    public String getExportIdentifier() {
        return StringHelper.qualify(this.getTable().getExportIdentifier(), "UK-" + this.getName());
    }

    public boolean isNameExplicit() {
        return this.nameExplicit;
    }

    public void setNameExplicit(boolean nameExplicit) {
        this.nameExplicit = nameExplicit;
    }

    public boolean isExplicit() {
        return this.explicit;
    }

    public void setExplicit(boolean explicit) {
        this.explicit = explicit;
    }

    public boolean hasNullableColumn() {
        for (Column column : this.getColumns()) {
            Column tableColumn = this.getTable().getColumn(column);
            if (tableColumn == null || !tableColumn.isNullable()) continue;
            return true;
        }
        return false;
    }
}

