/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.config;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.internals.BrokerSecurityConfigs;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.coordinator.group.GroupCoordinatorConfig;
import org.apache.kafka.coordinator.group.modern.share.ShareGroupConfig;
import org.apache.kafka.coordinator.share.ShareCoordinatorConfig;
import org.apache.kafka.coordinator.transaction.AddPartitionsToTxnConfig;
import org.apache.kafka.coordinator.transaction.TransactionLogConfig;
import org.apache.kafka.coordinator.transaction.TransactionStateManagerConfig;
import org.apache.kafka.network.SocketServerConfigs;
import org.apache.kafka.raft.MetadataLogConfig;
import org.apache.kafka.raft.QuorumConfig;
import org.apache.kafka.server.config.DelegationTokenManagerConfigs;
import org.apache.kafka.server.config.KRaftConfigs;
import org.apache.kafka.server.config.QuotaConfig;
import org.apache.kafka.server.config.ReplicationConfigs;
import org.apache.kafka.server.config.ServerConfigs;
import org.apache.kafka.server.log.remote.storage.RemoteLogManagerConfig;
import org.apache.kafka.server.metrics.MetricConfigs;
import org.apache.kafka.server.util.Csv;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.apache.kafka.storage.internals.log.LogConfig;

public abstract class AbstractKafkaConfig
extends AbstractConfig {
    public static final ConfigDef CONFIG_DEF = Utils.mergeConfigs(List.of(RemoteLogManagerConfig.configDef(), ServerConfigs.CONFIG_DEF, KRaftConfigs.CONFIG_DEF, MetadataLogConfig.CONFIG_DEF, SocketServerConfigs.CONFIG_DEF, ReplicationConfigs.CONFIG_DEF, GroupCoordinatorConfig.CONFIG_DEF, CleanerConfig.CONFIG_DEF, LogConfig.SERVER_CONFIG_DEF, ShareGroupConfig.CONFIG_DEF, ShareCoordinatorConfig.CONFIG_DEF, TransactionLogConfig.CONFIG_DEF, TransactionStateManagerConfig.CONFIG_DEF, QuorumConfig.CONFIG_DEF, MetricConfigs.CONFIG_DEF, QuotaConfig.CONFIG_DEF, BrokerSecurityConfigs.CONFIG_DEF, DelegationTokenManagerConfigs.CONFIG_DEF, AddPartitionsToTxnConfig.CONFIG_DEF));

    public AbstractKafkaConfig(ConfigDef definition, Map<?, ?> originals, Map<String, ?> configProviderProps, boolean doLog) {
        super(definition, originals, configProviderProps, doLog);
    }

    public List<String> logDirs() {
        return Csv.parseCsvList((String)Optional.ofNullable(this.getString("log.dirs")).orElse(this.getString("log.dir")));
    }

    public int numIoThreads() {
        return this.getInt("num.io.threads");
    }

    public int numReplicaFetchers() {
        return this.getInt("num.replica.fetchers");
    }

    public int numRecoveryThreadsPerDataDir() {
        return this.getInt("num.recovery.threads.per.data.dir");
    }

    public int backgroundThreads() {
        return this.getInt("background.threads");
    }

    public int brokerId() {
        return this.getInt("broker.id");
    }

    public int requestTimeoutMs() {
        return this.getInt("request.timeout.ms");
    }

    public List<String> controllerListenerNames() {
        return Csv.parseCsvList((String)this.getString("controller.listener.names"));
    }

    public ListenerName interBrokerListenerName() {
        return this.interBrokerListenerNameAndSecurityProtocol().getKey();
    }

    public SecurityProtocol interBrokerSecurityProtocol() {
        return this.interBrokerListenerNameAndSecurityProtocol().getValue();
    }

    public Map<ListenerName, SecurityProtocol> effectiveListenerSecurityProtocolMap() {
        Map<ListenerName, SecurityProtocol> mapValue = AbstractKafkaConfig.getMap("listener.security.protocol.map", this.getString("listener.security.protocol.map")).entrySet().stream().collect(Collectors.toMap(e -> ListenerName.normalised((String)((String)e.getKey())), e -> AbstractKafkaConfig.securityProtocol((String)e.getValue(), "listener.security.protocol.map")));
        if (!this.originals().containsKey("listener.security.protocol.map")) {
            if (this.controllerListenerNames().stream().anyMatch(AbstractKafkaConfig::isSslOrSasl) || Csv.parseCsvList((String)this.getString("listeners")).stream().anyMatch(listenerName -> AbstractKafkaConfig.isSslOrSasl(AbstractKafkaConfig.parseListenerName(listenerName)))) {
                return mapValue;
            }
            mapValue.putAll(this.controllerListenerNames().stream().filter(listenerName -> !SecurityProtocol.PLAINTEXT.name.equals(listenerName)).collect(Collectors.toMap(ListenerName::new, ignored -> SecurityProtocol.PLAINTEXT)));
            return mapValue;
        }
        return mapValue;
    }

    public static Map<String, String> getMap(String propName, String propValue) {
        try {
            return Csv.parseCsvMap((String)propValue);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Error parsing configuration property '%s': %s", propName, e.getMessage()));
        }
    }

    private static SecurityProtocol securityProtocol(String protocolName, String configName) {
        try {
            return SecurityProtocol.forName((String)protocolName);
        }
        catch (IllegalArgumentException e) {
            throw new ConfigException(String.format("Invalid security protocol `%s` defined in %s", protocolName, configName));
        }
    }

    private Map.Entry<ListenerName, SecurityProtocol> interBrokerListenerNameAndSecurityProtocol() {
        String interBrokerListenerName = this.getString("inter.broker.listener.name");
        if (interBrokerListenerName != null) {
            if (this.originals().containsKey("security.inter.broker.protocol")) {
                throw new ConfigException(String.format("Only one of %s and %s should be set.", "inter.broker.listener.name", "security.inter.broker.protocol"));
            }
            ListenerName listenerName = ListenerName.normalised((String)interBrokerListenerName);
            SecurityProtocol securityProtocol = this.effectiveListenerSecurityProtocolMap().get(listenerName);
            if (securityProtocol == null) {
                throw new ConfigException("Listener with name " + listenerName.value() + " defined in inter.broker.listener.name not found in listener.security.protocol.map.");
            }
            return Map.entry(listenerName, securityProtocol);
        }
        SecurityProtocol securityProtocol = AbstractKafkaConfig.securityProtocol(this.getString("security.inter.broker.protocol"), "security.inter.broker.protocol");
        return Map.entry(ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol);
    }

    private static boolean isSslOrSasl(String name) {
        return name.equals(SecurityProtocol.SSL.name) || name.equals(SecurityProtocol.SASL_SSL.name) || name.equals(SecurityProtocol.SASL_PLAINTEXT.name);
    }

    private static String parseListenerName(String connectionString) {
        int firstColon = connectionString.indexOf(58);
        if (firstColon < 0) {
            throw new KafkaException("Unable to parse a listener name from " + connectionString);
        }
        return connectionString.substring(0, firstColon).toUpperCase(Locale.ROOT);
    }
}

