/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.DebugData;
import ghidra.app.util.bin.format.pdb2.pdbreader.ImageSectionHeader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbDebugInfo;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbNewDebugInfo;
import ghidra.app.util.bin.format.pdb2.pdbreader.SegmentMapDescription;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractCompile2MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.Compile3MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.PeCoffSectionMsSymbol;
import ghidra.app.util.pdb.pdbapplicator.PdbAddressManager;
import ghidra.app.util.pdb.pdbapplicator.PdbApplicator;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.exception.CancelledException;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import org.apache.commons.collections4.CollectionUtils;

abstract class PdbAddressCalculator {
    private Address imageBase;
    protected List<SegmentInfo> segmentInfo = new ArrayList<SegmentInfo>();
    private int maxSegment;

    static PdbAddressCalculator chooseAddressCalculator(PdbApplicator applicator, Address imageBase) throws CancelledException, PdbException {
        MemoryBlock[] memoryBlocks;
        List<SegmentMapDescription> segmentMapDescription;
        AbstractPdb pdb = applicator.getPdb();
        PdbDebugInfo dbi = pdb.getDebugInfo();
        if (dbi instanceof PdbNewDebugInfo) {
            DebugData debugData = ((PdbNewDebugInfo)dbi).getDebugData();
            List<ImageSectionHeader> imageSectionHeaders = debugData.getImageSectionHeadersOrig();
            if (imageSectionHeaders != null) {
                SortedMap<Long, Long> omapFromSource = debugData.getOmapFromSource();
                if (omapFromSource != null) {
                    return new ImageHeaderWithOmapAddressCalculator(imageBase, imageSectionHeaders, omapFromSource);
                }
                return new ImageHeaderAddressCalculator(imageBase, imageSectionHeaders);
            }
            imageSectionHeaders = debugData.getImageSectionHeaders();
            if (imageSectionHeaders != null) {
                return new ImageHeaderAddressCalculator(imageBase, imageSectionHeaders);
            }
        }
        if (dbi != null && (segmentMapDescription = dbi.getSegmentMapList()) != null) {
            return new SegmentMapAddressCalculator(imageBase, segmentMapDescription);
        }
        List<PeCoffSectionMsSymbol> peCoffSectionSymbols = applicator.getLinkerPeCoffSectionSymbols();
        if (!CollectionUtils.isEmpty(peCoffSectionSymbols)) {
            long correction = PdbAddressCalculator.getCorrection(applicator);
            return new PeCoffSectionAddressCalculator(imageBase, correction, peCoffSectionSymbols);
        }
        Program program = applicator.getProgram();
        if (program != null && !CollectionUtils.sizeIsEmpty((Object)(memoryBlocks = program.getMemory().getBlocks()))) {
            return new MemoryMapAddressCalculator(imageBase, memoryBlocks);
        }
        return null;
    }

    static long getCorrection(PdbApplicator applicator) throws CancelledException, PdbException {
        AbstractMsSymbol symbol = applicator.getLinkerModuleCompileSymbol();
        String name = "";
        if (symbol instanceof Compile3MsSymbol) {
            Compile3MsSymbol compile3MsSymbol = (Compile3MsSymbol)symbol;
            name = compile3MsSymbol.getCompilerVersionString();
        } else if (symbol instanceof AbstractCompile2MsSymbol) {
            AbstractCompile2MsSymbol compile2MsSymbol = (AbstractCompile2MsSymbol)symbol;
            name = compile2MsSymbol.getCompilerVersionString();
        }
        if ("map2pdb".equals(name)) {
            return applicator.getOriginalImageBase();
        }
        return 0L;
    }

    PdbAddressCalculator(Address imageBase, List<SegmentInfo> segmentInfo) {
        this.segmentInfo = segmentInfo;
        this.imageBase = imageBase;
        this.maxSegment = segmentInfo.size() + 1;
    }

    Address getAddress(int segment, long offset) {
        if (segment > this.maxSegment) {
            return PdbAddressManager.BAD_ADDRESS;
        }
        if (segment == 0 || segment == this.maxSegment) {
            return PdbAddressManager.EXTERNAL_ADDRESS;
        }
        Long rva = this.getRva(segment, offset);
        if (rva == null) {
            return PdbAddressManager.BAD_ADDRESS;
        }
        if (rva == 0L) {
            return PdbAddressManager.ZERO_ADDRESS;
        }
        return this.imageBase.add(rva.longValue());
    }

    protected Long getRva(int segment, long offset) {
        return this.segmentInfo.get(segment - 1).getStart() + offset;
    }

    protected static List<SegmentInfo> synthesizeSegmentInfo(List<SegmentInfo> segments, long firstSectionOffset, long imageAlign) {
        long mask = -imageAlign;
        long addend = imageAlign - 1L;
        long determinedSectionOffset = firstSectionOffset;
        long sectionLength = 0L;
        ArrayList<SegmentInfo> synthesizedSegmentInfo = new ArrayList<SegmentInfo>();
        for (SegmentInfo info : segments) {
            long origSectionOffset = info.getStart();
            determinedSectionOffset = origSectionOffset != 0L ? origSectionOffset : (determinedSectionOffset += sectionLength + addend & mask);
            sectionLength = info.getLength();
            SegmentInfo synthesized = new SegmentInfo(determinedSectionOffset, sectionLength);
            synthesizedSegmentInfo.add(synthesized);
        }
        return synthesizedSegmentInfo;
    }

    static class ImageHeaderWithOmapAddressCalculator
    extends PdbAddressCalculator {
        private SortedMap<Long, Long> omapFromSource;

        ImageHeaderWithOmapAddressCalculator(Address imageBase, List<ImageSectionHeader> imageSectionHeaders, SortedMap<Long, Long> omapFromSource) {
            super(imageBase, ImageHeaderAddressCalculator.init(imageBase, imageSectionHeaders));
            this.omapFromSource = omapFromSource;
        }

        @Override
        protected Long getRva(int segment, long offset) {
            return this.applyOMap(super.getRva(segment, offset));
        }

        private Long applyOMap(Long relativeVirtualAddress) {
            SortedMap<Long, Long> headMap = this.omapFromSource.headMap(relativeVirtualAddress + 1L);
            if (headMap.isEmpty()) {
                return null;
            }
            long from = headMap.lastKey();
            long to = (Long)headMap.get(from);
            if (to == 0L) {
                return 0L;
            }
            return to + (relativeVirtualAddress - from);
        }
    }

    static class ImageHeaderAddressCalculator
    extends PdbAddressCalculator {
        ImageHeaderAddressCalculator(Address imageBase, List<ImageSectionHeader> imageSectionHeaders) {
            super(imageBase, ImageHeaderAddressCalculator.init(imageBase, imageSectionHeaders));
        }

        static List<SegmentInfo> init(Address imageBase, List<ImageSectionHeader> imageSectionHeaders) {
            ArrayList<SegmentInfo> segments = new ArrayList<SegmentInfo>();
            for (ImageSectionHeader imageSectionHeader : imageSectionHeaders) {
                SegmentInfo segment = new SegmentInfo(imageSectionHeader.getVirtualAddress(), imageSectionHeader.getRawDataSize());
                segments.add(segment);
            }
            return segments;
        }
    }

    static class SegmentMapAddressCalculator
    extends PdbAddressCalculator {
        SegmentMapAddressCalculator(Address imageBase, List<SegmentMapDescription> segmentMapDescriptions) {
            super(imageBase, SegmentMapAddressCalculator.init(imageBase, segmentMapDescriptions));
        }

        private static List<SegmentInfo> init(Address imageBase, List<SegmentMapDescription> segmentMapDescriptions) {
            ArrayList<SegmentInfo> segments = new ArrayList<SegmentInfo>();
            for (SegmentMapDescription smd : segmentMapDescriptions) {
                SegmentInfo segment = new SegmentInfo(smd.getOffset(), smd.getLength());
                segments.add(segment);
            }
            return SegmentMapAddressCalculator.synthesizeSegmentInfo(segments, 4096L, 4096L);
        }
    }

    static class PeCoffSectionAddressCalculator
    extends PdbAddressCalculator {
        PeCoffSectionAddressCalculator(Address imageBase, long correction, List<PeCoffSectionMsSymbol> peCoffSectionSymbols) {
            super(imageBase, PeCoffSectionAddressCalculator.init(imageBase, correction, peCoffSectionSymbols));
        }

        private static List<SegmentInfo> init(Address imageBase, long correction, List<PeCoffSectionMsSymbol> peCoffSectionSymbols) {
            ArrayList<SegmentInfo> segments = new ArrayList<SegmentInfo>();
            for (PeCoffSectionMsSymbol symbol : peCoffSectionSymbols) {
                long rva = symbol.getRva();
                if (rva == 0L || rva >= correction) continue;
                correction = 0L;
                break;
            }
            for (PeCoffSectionMsSymbol symbol : peCoffSectionSymbols) {
                int offset = symbol.getRva();
                if (offset != 0) {
                    offset = (int)((long)offset - correction);
                }
                SegmentInfo segment = new SegmentInfo(offset, symbol.getLength());
                segments.add(segment);
            }
            return segments;
        }
    }

    static class MemoryMapAddressCalculator
    extends PdbAddressCalculator {
        MemoryMapAddressCalculator(Address imageBase, MemoryBlock[] memoryBlocks) {
            super(imageBase, MemoryMapAddressCalculator.init(imageBase, memoryBlocks));
        }

        private static List<SegmentInfo> init(Address imageBase, MemoryBlock[] blocks) {
            ArrayList<SegmentInfo> segments = new ArrayList<SegmentInfo>();
            for (MemoryBlock block : blocks) {
                long offset = block.getStart().subtract(imageBase);
                SegmentInfo segment = new SegmentInfo(offset, block.getSize());
                segments.add(segment);
            }
            return segments;
        }
    }

    private static class SegmentInfo {
        private long start;
        private long length;

        SegmentInfo(long startIn, long lengthIn) {
            this.start = startIn;
            this.length = lengthIn;
        }

        public long getStart() {
            return this.start;
        }

        public long getLength() {
            return this.length;
        }

        public String toString() {
            return String.format("start: %08x length: %08x", this.start, this.length);
        }
    }
}

