/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.ext.awt.image.spi;

import io.sf.carte.echosvg.ext.awt.image.renderable.Filter;
import io.sf.carte.echosvg.ext.awt.image.spi.ErrorConstants;
import io.sf.carte.echosvg.ext.awt.image.spi.ImageTagRegistry;
import io.sf.carte.echosvg.ext.awt.image.spi.RegistryEntry;
import io.sf.carte.echosvg.util.ParsedURL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AbstractRegistryEntry
implements RegistryEntry,
ErrorConstants {
    private String name;
    private float priority;
    private List<String> exts;
    private List<String> mimeTypes;

    public AbstractRegistryEntry(String name, float priority, String[] exts, String[] mimeTypes) {
        this.name = name;
        this.priority = priority;
        this.exts = new ArrayList<String>(exts.length);
        for (String ext : exts) {
            this.exts.add(ext);
        }
        this.exts = Collections.unmodifiableList(this.exts);
        this.mimeTypes = new ArrayList<String>(mimeTypes.length);
        for (String mimeType : mimeTypes) {
            this.mimeTypes.add(mimeType);
        }
        this.mimeTypes = Collections.unmodifiableList(this.mimeTypes);
    }

    public AbstractRegistryEntry(String name, float priority, String ext, String mimeType) {
        this.name = name;
        this.priority = priority;
        this.exts = new ArrayList<String>(1);
        this.exts.add(ext);
        this.exts = Collections.unmodifiableList(this.exts);
        this.mimeTypes = new ArrayList<String>(1);
        this.mimeTypes.add(mimeType);
        this.mimeTypes = Collections.unmodifiableList(this.mimeTypes);
    }

    @Override
    public String getFormatName() {
        return this.name;
    }

    @Override
    public List<String> getStandardExtensions() {
        return this.exts;
    }

    @Override
    public List<String> getMimeTypes() {
        return this.mimeTypes;
    }

    @Override
    public float getPriority() {
        return this.priority;
    }

    protected Filter getFormatBrokenLinkImage(ParsedURL origURL) {
        Object[] errParam;
        String errCode;
        if (origURL != null) {
            errCode = "url.format.unreadable";
            errParam = new Object[]{this.getFormatName(), origURL};
        } else {
            errCode = "stream.format.unreadable";
            errParam = new Object[]{this.getFormatName()};
        }
        return ImageTagRegistry.getBrokenLinkImage(this, errCode, errParam);
    }

    protected Filter getFormatMsgBrokenLinkImage(ParsedURL origURL, Throwable t) {
        Object[] errParam;
        String errCode;
        String message = t.getClass().getSimpleName();
        if (origURL != null) {
            errCode = "url.format.unreadable.msg";
            errParam = new Object[]{this.getFormatName(), origURL, message};
        } else {
            errCode = "stream.format.unreadable.msg";
            errParam = new Object[]{this.getFormatName(), message};
        }
        return ImageTagRegistry.getBrokenLinkImage(this, errCode, errParam);
    }
}

