/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.mindmapmode;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import javax.net.ssl.SSLHandshakeException;
import org.freeplane.core.util.FreeplaneVersion;
import org.freeplane.core.util.LogUtils;

class HttpVersionClient {
    private String history = "";
    private FreeplaneVersion remoteVersion = null;
    private boolean successful = false;
    private URL remoteVersionDownloadUrl;
    private URL remoteVersionChangelogUrl;

    private static URL getUrl(String versionUrl) {
        try {
            return new URL(versionUrl);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public HttpVersionClient(String versionUrl, FreeplaneVersion currentVersion) {
        this(HttpVersionClient.getUrl(versionUrl), currentVersion);
    }

    public HttpVersionClient(URL url, FreeplaneVersion currentVersion) {
        this.initialize(url, currentVersion);
    }

    private void initialize(URL url, FreeplaneVersion currentVersion) {
        try {
            if (this.isPropertyUrl(url)) {
                this.parseProperties(url, currentVersion);
            } else {
                this.parseHistory(url, currentVersion);
            }
        }
        catch (SSLHandshakeException ex) {
            if (url.getProtocol().equalsIgnoreCase("https")) {
                try {
                    URL httpUrl = new URL(url.toString().replaceFirst(url.getProtocol(), "http"));
                    this.initialize(httpUrl, currentVersion);
                }
                catch (MalformedURLException e) {
                    LogUtils.severe((Throwable)e);
                }
            }
        }
        catch (NullPointerException e) {
            LogUtils.warn((String)("problem with update check for url (" + url + ")"), (Throwable)e);
        }
        catch (IOException e) {
            LogUtils.warn((String)("Could not read update url (" + url + ") - check your internet connection."));
        }
        catch (IllegalArgumentException e) {
            LogUtils.warn((String)("Could not read version from " + url + ":" + e.getMessage()));
        }
    }

    private boolean isPropertyUrl(URL url) {
        return url.getPath() != null && url.getPath().endsWith(".properties");
    }

    private boolean parseProperties(URL url, FreeplaneVersion currentVersion) throws IOException {
        Properties versionProperties = new Properties();
        versionProperties.load(new InputStreamReader(url.openConnection().getInputStream(), StandardCharsets.UTF_8));
        if (versionProperties.getProperty("version") != null) {
            this.remoteVersion = FreeplaneVersion.getVersion((String)versionProperties.getProperty("version"));
            this.successful = true;
            this.remoteVersionDownloadUrl = this.parseUrl(versionProperties.getProperty("downloadUrl"));
            this.remoteVersionChangelogUrl = this.parseUrl(versionProperties.getProperty("changelogUrl"));
            return this.remoteVersion.compareTo((org.freeplane.api.FreeplaneVersion)currentVersion) > 0;
        }
        LogUtils.warn((String)("add-on update: no version found in " + url));
        return false;
    }

    private void parseHistory(URL url, FreeplaneVersion currentVersion) throws IOException {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(url.openConnection().getInputStream(), StandardCharsets.UTF_8));){
            String line = in.readLine();
            while (line != null && !line.startsWith("=====")) {
                line = in.readLine();
            }
            while (line != null && line.startsWith("=====")) {
                line = in.readLine();
            }
            if (line == null) {
                return;
            }
            this.remoteVersion = FreeplaneVersion.getVersion((String)line);
            this.successful = true;
            if (this.remoteVersion.compareTo((org.freeplane.api.FreeplaneVersion)currentVersion) > 0) {
                this.parseHistory(currentVersion, in, line);
            }
        }
    }

    private void parseHistory(FreeplaneVersion currentVersion, BufferedReader in, String firstLine) throws IOException {
        StringBuilder historyBuffer = new StringBuilder();
        historyBuffer.append(firstLine);
        historyBuffer.append('\n');
        String line = in.readLine();
        while (line != null) {
            try {
                FreeplaneVersion version = FreeplaneVersion.getVersion((String)line);
                if (version.compareTo((org.freeplane.api.FreeplaneVersion)currentVersion) <= 0) {
                    break;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            historyBuffer.append(line);
            historyBuffer.append('\n');
            line = in.readLine();
        }
        this.history = historyBuffer.toString();
    }

    private URL parseUrl(String urlString) {
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public String getHistory() {
        return this.history;
    }

    public FreeplaneVersion getRemoteVersion() {
        return this.remoteVersion;
    }

    public URL getRemoteVersionDownloadUrl() {
        return this.remoteVersionDownloadUrl;
    }

    public URL getRemoteVersionChangelogUrl() {
        return this.remoteVersionChangelogUrl;
    }

    public boolean isSuccessful() {
        return this.successful;
    }
}

