/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.Polygon;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Transform;
import org.eclipse.swt.graphics.Color;

public class PolygonDecoration
extends Polygon
implements RotatableDecoration {
    public static final PointList TRIANGLE_TIP = new PointList();
    public static final PointList INVERTED_TRIANGLE_TIP = new PointList();
    private final Point location = new Point();
    private PointList template = TRIANGLE_TIP;
    private final Transform transform = new Transform();

    static {
        TRIANGLE_TIP.addPoint(0, 0);
        TRIANGLE_TIP.addPoint(-1, 1);
        TRIANGLE_TIP.addPoint(-1, -1);
        INVERTED_TRIANGLE_TIP.addPoint(0, 1);
        INVERTED_TRIANGLE_TIP.addPoint(0, -1);
        INVERTED_TRIANGLE_TIP.addPoint(-1, 0);
    }

    public PolygonDecoration() {
        this.setFill(true);
        this.setScale(7.0, 3.0);
    }

    @Override
    public Color getLocalBackgroundColor() {
        if (super.getLocalBackgroundColor() == null) {
            return this.getForegroundColor();
        }
        return super.getLocalBackgroundColor();
    }

    @Override
    public PointList getPoints() {
        if (this.points == null) {
            this.points = new PointList();
            int i = 0;
            while (i < this.template.size()) {
                this.points.addPoint(this.transform.getTransformed(this.template.getPoint(i)));
                ++i;
            }
        }
        return this.points;
    }

    @Override
    public void setLocation(Point p) {
        this.points = null;
        this.bounds = null;
        this.location.setLocation(p);
        this.transform.setTranslation(p.x, p.y);
    }

    public void setTemplate(PointList pl) {
        this.erase();
        this.template = pl;
        this.points = null;
        this.bounds = null;
        this.repaint();
    }

    public void setScale(double x, double y) {
        this.points = null;
        this.bounds = null;
        this.transform.setScale(x, y);
    }

    @Override
    public void setReferencePoint(Point ref) {
        Point pt = Point.SINGLETON;
        pt.setLocation(ref);
        pt.negate().translate(this.location);
        this.setRotation(Math.atan2(pt.y, pt.x));
    }

    public void setRotation(double angle) {
        this.points = null;
        this.bounds = null;
        this.transform.setRotation(angle);
    }
}

