/*
 * Decompiled with CFR 0.152.
 */
package org.cugos.wkg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.cugos.wkg.Coordinate;
import org.cugos.wkg.Dimension;
import org.cugos.wkg.Geometry;
import org.cugos.wkg.WKTWriter;

public abstract class AbstractGeometryCollection<T extends Geometry>
extends Geometry {
    protected final List<T> geometries;

    public AbstractGeometryCollection(List<T> geometries, Dimension dimension, String srid) {
        super(dimension, srid);
        this.geometries = Collections.unmodifiableList(geometries);
    }

    @Override
    public boolean isEmpty() {
        return this.geometries.isEmpty();
    }

    @Override
    public String toString() {
        return new WKTWriter().write(this);
    }

    @Override
    public int getNumberOfCoordinates() {
        int numberOfCoordinates = 0;
        for (Geometry geometry : this.geometries) {
            numberOfCoordinates += geometry.getNumberOfCoordinates();
        }
        return numberOfCoordinates;
    }

    @Override
    public List<Coordinate> getCoordinates() {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        for (Geometry geometry : this.geometries) {
            coordinates.addAll(geometry.getCoordinates());
        }
        return Collections.unmodifiableList(coordinates);
    }
}

