/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.RequiredTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3.model.DestinationResult;
import software.amazon.awssdk.services.s3.model.InventoryTableConfigurationResult;
import software.amazon.awssdk.services.s3.model.JournalTableConfigurationResult;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetadataConfigurationResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetadataConfigurationResult> {
    private static final SdkField<DestinationResult> DESTINATION_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DestinationResult").getter(MetadataConfigurationResult.getter(MetadataConfigurationResult::destinationResult)).setter(MetadataConfigurationResult.setter(Builder::destinationResult)).constructor(DestinationResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationResult").unmarshallLocationName("DestinationResult").build(), RequiredTrait.create()}).build();
    private static final SdkField<JournalTableConfigurationResult> JOURNAL_TABLE_CONFIGURATION_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("JournalTableConfigurationResult").getter(MetadataConfigurationResult.getter(MetadataConfigurationResult::journalTableConfigurationResult)).setter(MetadataConfigurationResult.setter(Builder::journalTableConfigurationResult)).constructor(JournalTableConfigurationResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JournalTableConfigurationResult").unmarshallLocationName("JournalTableConfigurationResult").build()}).build();
    private static final SdkField<InventoryTableConfigurationResult> INVENTORY_TABLE_CONFIGURATION_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InventoryTableConfigurationResult").getter(MetadataConfigurationResult.getter(MetadataConfigurationResult::inventoryTableConfigurationResult)).setter(MetadataConfigurationResult.setter(Builder::inventoryTableConfigurationResult)).constructor(InventoryTableConfigurationResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InventoryTableConfigurationResult").unmarshallLocationName("InventoryTableConfigurationResult").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_RESULT_FIELD, JOURNAL_TABLE_CONFIGURATION_RESULT_FIELD, INVENTORY_TABLE_CONFIGURATION_RESULT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MetadataConfigurationResult.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final DestinationResult destinationResult;
    private final JournalTableConfigurationResult journalTableConfigurationResult;
    private final InventoryTableConfigurationResult inventoryTableConfigurationResult;

    private MetadataConfigurationResult(BuilderImpl builder) {
        this.destinationResult = builder.destinationResult;
        this.journalTableConfigurationResult = builder.journalTableConfigurationResult;
        this.inventoryTableConfigurationResult = builder.inventoryTableConfigurationResult;
    }

    public final DestinationResult destinationResult() {
        return this.destinationResult;
    }

    public final JournalTableConfigurationResult journalTableConfigurationResult() {
        return this.journalTableConfigurationResult;
    }

    public final InventoryTableConfigurationResult inventoryTableConfigurationResult() {
        return this.inventoryTableConfigurationResult;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationResult());
        hashCode = 31 * hashCode + Objects.hashCode(this.journalTableConfigurationResult());
        hashCode = 31 * hashCode + Objects.hashCode(this.inventoryTableConfigurationResult());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetadataConfigurationResult)) {
            return false;
        }
        MetadataConfigurationResult other = (MetadataConfigurationResult)obj;
        return Objects.equals(this.destinationResult(), other.destinationResult()) && Objects.equals(this.journalTableConfigurationResult(), other.journalTableConfigurationResult()) && Objects.equals(this.inventoryTableConfigurationResult(), other.inventoryTableConfigurationResult());
    }

    public final String toString() {
        return ToString.builder((String)"MetadataConfigurationResult").add("DestinationResult", (Object)this.destinationResult()).add("JournalTableConfigurationResult", (Object)this.journalTableConfigurationResult()).add("InventoryTableConfigurationResult", (Object)this.inventoryTableConfigurationResult()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DestinationResult": {
                return Optional.ofNullable(clazz.cast(this.destinationResult()));
            }
            case "JournalTableConfigurationResult": {
                return Optional.ofNullable(clazz.cast(this.journalTableConfigurationResult()));
            }
            case "InventoryTableConfigurationResult": {
                return Optional.ofNullable(clazz.cast(this.inventoryTableConfigurationResult()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DestinationResult", DESTINATION_RESULT_FIELD);
        map.put("JournalTableConfigurationResult", JOURNAL_TABLE_CONFIGURATION_RESULT_FIELD);
        map.put("InventoryTableConfigurationResult", INVENTORY_TABLE_CONFIGURATION_RESULT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetadataConfigurationResult, T> g) {
        return obj -> g.apply((MetadataConfigurationResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DestinationResult destinationResult;
        private JournalTableConfigurationResult journalTableConfigurationResult;
        private InventoryTableConfigurationResult inventoryTableConfigurationResult;

        private BuilderImpl() {
        }

        private BuilderImpl(MetadataConfigurationResult model) {
            this.destinationResult(model.destinationResult);
            this.journalTableConfigurationResult(model.journalTableConfigurationResult);
            this.inventoryTableConfigurationResult(model.inventoryTableConfigurationResult);
        }

        public final DestinationResult.Builder getDestinationResult() {
            return this.destinationResult != null ? this.destinationResult.toBuilder() : null;
        }

        public final void setDestinationResult(DestinationResult.BuilderImpl destinationResult) {
            this.destinationResult = destinationResult != null ? destinationResult.build() : null;
        }

        @Override
        public final Builder destinationResult(DestinationResult destinationResult) {
            this.destinationResult = destinationResult;
            return this;
        }

        public final JournalTableConfigurationResult.Builder getJournalTableConfigurationResult() {
            return this.journalTableConfigurationResult != null ? this.journalTableConfigurationResult.toBuilder() : null;
        }

        public final void setJournalTableConfigurationResult(JournalTableConfigurationResult.BuilderImpl journalTableConfigurationResult) {
            this.journalTableConfigurationResult = journalTableConfigurationResult != null ? journalTableConfigurationResult.build() : null;
        }

        @Override
        public final Builder journalTableConfigurationResult(JournalTableConfigurationResult journalTableConfigurationResult) {
            this.journalTableConfigurationResult = journalTableConfigurationResult;
            return this;
        }

        public final InventoryTableConfigurationResult.Builder getInventoryTableConfigurationResult() {
            return this.inventoryTableConfigurationResult != null ? this.inventoryTableConfigurationResult.toBuilder() : null;
        }

        public final void setInventoryTableConfigurationResult(InventoryTableConfigurationResult.BuilderImpl inventoryTableConfigurationResult) {
            this.inventoryTableConfigurationResult = inventoryTableConfigurationResult != null ? inventoryTableConfigurationResult.build() : null;
        }

        @Override
        public final Builder inventoryTableConfigurationResult(InventoryTableConfigurationResult inventoryTableConfigurationResult) {
            this.inventoryTableConfigurationResult = inventoryTableConfigurationResult;
            return this;
        }

        public MetadataConfigurationResult build() {
            return new MetadataConfigurationResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetadataConfigurationResult> {
        public Builder destinationResult(DestinationResult var1);

        default public Builder destinationResult(Consumer<DestinationResult.Builder> destinationResult) {
            return this.destinationResult((DestinationResult)((DestinationResult.Builder)DestinationResult.builder().applyMutation(destinationResult)).build());
        }

        public Builder journalTableConfigurationResult(JournalTableConfigurationResult var1);

        default public Builder journalTableConfigurationResult(Consumer<JournalTableConfigurationResult.Builder> journalTableConfigurationResult) {
            return this.journalTableConfigurationResult((JournalTableConfigurationResult)((JournalTableConfigurationResult.Builder)JournalTableConfigurationResult.builder().applyMutation(journalTableConfigurationResult)).build());
        }

        public Builder inventoryTableConfigurationResult(InventoryTableConfigurationResult var1);

        default public Builder inventoryTableConfigurationResult(Consumer<InventoryTableConfigurationResult.Builder> inventoryTableConfigurationResult) {
            return this.inventoryTableConfigurationResult((InventoryTableConfigurationResult)((InventoryTableConfigurationResult.Builder)InventoryTableConfigurationResult.builder().applyMutation(inventoryTableConfigurationResult)).build());
        }
    }
}

