/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx;

import java.util.HashSet;
import java.util.Set;

public class ModuleUtil {
    private static final Set<Module> warnedModules = new HashSet<Module>();
    private static final Set<Package> warnedPackages = new HashSet<Package>();
    private static final Module MODULE_JAVA_BASE = Module.class.getModule();

    public static void incubatorWarning() {
        StackWalker stackWalker = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
        Class clazz = stackWalker.walk(stream -> stream.dropWhile(stackFrame -> {
            Class<?> clazz = stackFrame.getDeclaringClass();
            return ModuleUtil.class.equals(clazz) || MODULE_JAVA_BASE.equals(clazz.getModule());
        }).map(StackWalker.StackFrame::getDeclaringClass).findFirst().orElseThrow(IllegalStateException::new));
        Module module = clazz.getModule();
        if (!module.isNamed()) {
            Package package_ = clazz.getPackage();
            if (!warnedPackages.contains(package_)) {
                System.err.println("WARNING: Using incubating API from an unnamed module: " + String.valueOf(package_));
                warnedPackages.add(package_);
            }
            return;
        }
        if (!warnedModules.contains(module)) {
            System.err.println("WARNING: Using incubator modules: " + module.getName());
            warnedModules.add(module);
        }
    }

    private ModuleUtil() {
    }
}

