/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.util.Comparator;
import java.util.Objects;
import org.assertj.core.api.recursive.comparison.RecursiveComparisonConfiguration;
import org.assertj.core.api.recursive.comparison.RecursiveComparisonDifferenceCalculator;
import org.assertj.core.util.introspection.IntrospectionError;

public class ConfigurableRecursiveFieldByFieldComparator
implements Comparator<Object> {
    private RecursiveComparisonConfiguration configuration;
    private RecursiveComparisonDifferenceCalculator recursiveComparisonDifferenceCalculator;

    ConfigurableRecursiveFieldByFieldComparator(RecursiveComparisonConfiguration configuration, RecursiveComparisonDifferenceCalculator recursiveComparisonDifferenceCalculator) {
        Objects.requireNonNull(configuration, "RecursiveComparisonConfiguration must not be null");
        this.configuration = configuration;
        this.recursiveComparisonDifferenceCalculator = recursiveComparisonDifferenceCalculator;
    }

    public ConfigurableRecursiveFieldByFieldComparator(RecursiveComparisonConfiguration configuration) {
        this(configuration, new RecursiveComparisonDifferenceCalculator());
    }

    @Override
    public int compare(Object actual, Object other) {
        if (actual == null && other == null) {
            return 0;
        }
        if (actual == null || other == null) {
            return -1;
        }
        return this.areEqual(actual, other) ? 0 : -1;
    }

    protected boolean areEqual(Object actual, Object other) {
        try {
            return this.recursiveComparisonDifferenceCalculator.determineDifferences(actual, other, this.configuration).isEmpty();
        }
        catch (IntrospectionError e) {
            return false;
        }
    }

    public String toString() {
        return "recursive field/property by field/property comparator on all fields/properties using the following configuration:%n%s".formatted(this.configuration);
    }

    public int hashCode() {
        return Objects.hash(this.configuration);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigurableRecursiveFieldByFieldComparator other = (ConfigurableRecursiveFieldByFieldComparator)obj;
        return Objects.equals(this.configuration, other.configuration);
    }
}

